--[[                    General description and rules of use

It is the Lua scene to decrease the Heat Controller setpoint when the window is opened. 
The Scene assumes that one or more physical Door/Window Sensors are installed on windows to detect when the window is opened.
The Scene set a new lower set point for Heat Controller and keeps it as long as a specific window is left open.

This Scene does not use the internal Heat Controller's functionality to discover when the window is opened. For that purpose, please use my other solution based on Quick App.
For more reference, please visit my portal and watch several DIY videos explaining all in detail at:

https://www.portal.ztechnikazapanbrat.pl/filmpagescollection/670





-----------------------------------------------------------------------------------------------------
Warning!
The Scene requires necessarily settings for defining which window sensors influences which Heat Controllers. You can define as many sensors and thermostats as you like, but please divide them into groups.
e.g. assuming that one room has window sensors ids: 11, 12, 13 and they influence to reduce heating on thermostats ids: 21, 22, 23 located in the same room, you have to make the following configuration:

local sensorsAndHeatControllers = {
    { sensorIDs = {11, 12, 13}, heatControllerIDs = {21, 22, 23} },
    { },
    { },
    { }
}
 
If you have another room, add a similar definition to other lines.
-----------------------------------------------------------------------------------------------------


For more reference, please visit my portal and watch several DIY videos explaining all in details on:

https://www.portal.ztechnikazapanbrat.pl/filmpagescollection/670
https://www.portal.ztechnikazapanbrat.pl/ 


Designed by Lukasz Gawryjolek 2021
https://www.portal.ztechnikazapanbrat.pl/ 
Pierwsza platforma DIY na rynku dla Inteligentnego Domu
email: lukasz@ztechnikazapanbrat.pl

Release on DIY portal at: 2021.02.23
-------------------------------------
 2021.10.29 - edit description who to use it



]]








--[[  

Declaration/Triggers

 {    
    type = "se-start",    
    property = "start",    
    operator = "==",    
    value = true,    
    isTrigger = true
}

]]


--------------------------------------------------------
-------------- REQUIRED CONFIGURATION ------------------
local sensorsAndHeatControllers = {
    { sensorIDs = {0, 0, 0}, heatControllerIDs = {0, 0, 0} },
    { sensorIDs = {}, heatControllerIDs = {} },
    { sensorIDs = {}, heatControllerIDs = {} },
    { sensorIDs = {}, heatControllerIDs = {} }
}
--------------------------------------------------------



----------------------------------------------------------------------------------------
-- Code of the scene - DO NOT CHANGE IT !
----------------------------------------------------------------------------------------

function checkDoorWindowSensors()

  for k1, v1 in pairs(sensorsAndHeatControllers) do
    local sensors = v1.sensorIDs
    local heaters = v1.heatControllerIDs
    --print(json.encode(sensors), json.encode(heaters))
    for k2, v2 in pairs(sensors) do
        local open = fibaro.getValue(v2, "value")   

        if open == true then
            print("Window is open for sensor id: ", v2)
            decreaseScheduleTemp(heaters)
            break
        end
    end
  end
end

function decreaseScheduleTemp(heaters)

    local newSetpointDefinition = 
    {
        type = "thermostat",
        data = {
            mode = "Heat",
            setpoints = {
                {
                    type = "Heating",
                    unit = "C",
                    value = 14
                }
            }
        }
    }
        
    local durationDefinition = 
    {
        type = "Minutes",
        value = 5
    }

    print("Window is opened  -> new set point for Heat Controller IDs: ", json.encode(heaters))

    for k, v in pairs(heaters) do
        if fibaro.getType(v) == "com.fibaro.FGT001" then
            fibaro.call(v, 'setOverrideSchedule', json.encode(newSetpointDefinition) , json.encode(durationDefinition), '{}')

        --fibaro.call(47, 'setOverrideSchedule', '{"type":"thermostat","data":{"mode":"Heat","setpoints":[{"type":"Heating","unit":"C","value":28}]}}', '{"type":"Minutes","value":2}', '{}')


        else
            print("ERROR! Thermostat " .. v .. " does not exist !")
        end
    end
end

-- loop function
function timeFunc()
  checkDoorWindowSensors()
  
  fibaro.setTimeout(3 * 60 * 1000, timeFunc)

end


print("First run...")
timeFunc()

